/*:
 * @target MZ
 * @plugindesc SEやBGSの音量を規定の音量以上に設定するプラグイン
 * @author あなたの名前
 *
 * @command boostSEVolume
 * @text SEの音量を上げる
 * @desc 特定のSEの音量を指定した値に変更します。
 *
 * @arg seName
 * @type file
 * @dir audio/se
 * @text SEファイル
 * @desc 音量を上げるSEファイルを指定します。
 *
 * @arg volume
 * @type number
 * @min 0
 * @max 200
 * @default 100
 * @text 音量
 * @desc SEの音量を0～200の範囲で指定します。（デフォルト100、最大200）
 *
 * @command boostBGSVolume
 * @text BGSの音量を上げる
 * @desc 特定のBGSの音量を指定した値に変更します。
 *
 * @arg bgsName
 * @type file
 * @dir audio/bgs
 * @text BGSファイル
 * @desc 音量を上げるBGSファイルを指定します。
 *
 * @arg volume
 * @type number
 * @min 0
 * @max 200
 * @default 100
 * @text 音量
 * @desc BGSの音量を0～200の範囲で指定します。（デフォルト100、最大200）
 *
 * @help
 * このプラグインは、指定したSEやBGSの音量を通常の最大値である100を超えて
 * 200まで設定できるようにします。
 *
 * 使用方法:
 * 1. プラグインを有効化
 * 2. イベントのプラグインコマンドから「SEの音量を上げる」または
 *    「BGSの音量を上げる」を選択し、任意のファイルと音量を指定
 */

(() => {
    const pluginName = 'VolumeBoostPlugin';

    // SEの音量を変更するコマンド
    PluginManager.registerCommand(pluginName, 'boostSEVolume', args => {
        const seName = String(args.seName);
        let volume = Number(args.volume);

        // 音量を200に制限
        volume = Math.min(volume, 200);

        // SEを再生
        const se = {
            name: seName,
            volume: volume,
            pitch: 100,
            pan: 0
        };
        AudioManager.playSe(se);
    });

    // BGSの音量を変更するコマンド
    PluginManager.registerCommand(pluginName, 'boostBGSVolume', args => {
        const bgsName = String(args.bgsName);
        let volume = Number(args.volume);

        // 音量を200に制限
        volume = Math.min(volume, 200);

        // BGSを再生
        const bgs = {
            name: bgsName,
            volume: volume,
            pitch: 100,
            pan: 0
        };
        AudioManager.playBgs(bgs);
    });
})();
